package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions;

import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.util.LinkedHashMap;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Ouverture d'une session
 *
 */
public class OuvrirSession {

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(OuvrirSession.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSlotToken Identifiant du slot hbergant la carte
	 * @param lectureEcriture Boolen permettant de dterminer s'il s'agit d'une session en lecture/criture
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSlotToken, boolean lectureEcriture) throws ExceptionTraitement {


		try {
			
			if(librairie != null) {
		
				ResultatInfo resultat = new ResultatInfo("Ouverture d'une session en "+(lectureEcriture?"lecture criture":"lecture seule")+" (C_OpenSession)");
				LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();
				resultat.setInfos(infos);
				
				try {
		
					// Traitement  tester
					long session = librairie.C_OpenSession(idSlotToken, lectureEcriture?PKCS11Constants.CKF_SERIAL_SESSION|PKCS11Constants.CKF_RW_SESSION:PKCS11Constants.CKF_SERIAL_SESSION|PKCS11Constants.CKS_RO_PUBLIC_SESSION, null, null);
					
					// On stocke la session
					resultat.getObjets().add(session);
					
					// Formatage du rsultat
					infos.put("Identifiant de la session ouverte",Long.toString(session));
		
					
				} catch (PKCS11Exception e) {

					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
				
				return resultat;
				
			} else {
				
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_OUVRE, "La librairie est nulle");
				
			}

		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_OUVRE, "Une erreur inattendue est survenue");
			
		}

	}

}
